#version 400
//#version 330 core
varying vec2 texCoord;
uniform sampler2D colorMap;
uniform sampler2D depthMap;
uniform sampler2D blurintensity;
uniform sampler2D bokehsprite;
uniform float nearz;
uniform float nearblur;
uniform float farz;
uniform float farblur;
uniform int pass;

vec4 resultcolor;

void main (void)
{
    resultcolor=texture2D(colorMap, texCoord);
    //resultcolor=vec4(0.0f,1.0f,0.3f,1.0f);

    //float depth=float(double(double((texture2D(depthMap, texCoord)).r*256.0f)+double(texture2D(depthMap, texCoord).g)/double(65536.0)));
    float r1=texture2D(depthMap, texCoord).r;
    float g1=texture2D(depthMap, texCoord).g;
    float depth=float(((double(r1)*double(256.0))+double(g1))/double(65536.0));
    //float intensity=(texture2D(blurintensity, vec2(depth,0.0f))).r;

    //float intensity=1.0f-(depth*5000.0f);//this is a magic number, should fix camera depth properties instead
    //float gfactor=intensity*32.0f; //24 32 48
    depth=2*(1.0f-depth*5000.0f);
    depth=clamp(depth,0.0f,0.99f);
    float resultfar=(1.0f-abs(depth-farz))*farblur;
    float resultnear=(1.0f-abs(depth-nearz))*nearblur;
    float gfactor=(resultfar+resultnear);

    //float oddeven=float(gfactor)/2.0f;
    //if (oddeven!=floor(oddeven)) gfactor++; //we need an even number

    if (gfactor>1.0f && gfactor>pass){
        float gx=gfactor*(1.0f/1920.0f);
        float gy=gfactor*(1.0f/1080.0f);
        float d=0;
        vec2 center=vec2(texCoord.x+gx/2,texCoord.y+gy/2);
        float radius=gfactor/2;
        float fradius=floor(radius);
        float edgecase=radius-fradius;
        if (edgecase==0.0f) {edgecase=0.01f;radius+=edgecase;}
        float f=1.0f;
        float xf=edgecase;
        float yf=edgecase;
        resultcolor=vec4(0.0f);

        //if(float(pass)/2.0f==floor(float(pass)/2.0f))
        if (mod(pass, 2) < 1)
        {
            for (float y=-radius;y<radius;y+=yf){
                //for (float x=-radius;x<radius;x+=xf){
                {
                    float x=0.0f;
                    f=1.0f;
                    if (y==-radius||y==fradius) f=edgecase;
                    if (x==-radius||x==fradius) f*=edgecase;
                    float sprite=texture2D(bokehsprite, vec2((x+radius)/gfactor,(y+radius)/gfactor)).r;
                    //if (length(center-vec2(x,y))<radius){
                    if (sprite>0.0f)
                    {
                            float x1=texCoord.x-x*(1.0f/1920.0f); float y1=texCoord.y-y*(1.0f/1080.0f); x1=clamp(x1,0.0f,1.0f-1.0f/1920.0f); y1=clamp(y1,0.0f,1.0f-1.0f/1080.0f);
                            vec2 gtexCoord=vec2(x1,y1);
                        float r2=texture2D(depthMap, gtexCoord).r;
                        float g2=texture2D(depthMap, gtexCoord).g;
                        float depth2=float(((double(r2)*double(256.0))+double(g2))/double(65536.0));
                        depth2=2*(1.0f-depth2*5000.0f);
                        depth2=clamp(depth2,0.0f,0.99f);
                        if (depth2-depth>=-1.0f/500.0f)
                        {
                            f=f*sprite;
                            vec4 gcolor=texture2D(colorMap, gtexCoord);
                            //gcolor*=blur3[y*3+x];
                            resultcolor+=gcolor*f; d+=f;
                            float brightness=gcolor.r+gcolor.g+gcolor.b;
                            if (brightness>2.0f) {float fb=(brightness-2.0f)*24.0f;resultcolor+=fb*gcolor*f;d+=fb*f;}
                        }
                    }
                    if (x==-radius||x==fradius) xf=edgecase; else xf=1.0f;
                }
                if (y==-radius||y==fradius) yf=edgecase; else yf=1.0f;
            }
            resultcolor/=d;
        } else
        {
            {
            //for (float y=-radius;y<radius;y+=yf){
                float y=0.0f;
                for (float x=-radius;x<radius;x+=xf){
                    f=1.0f;
                    if (y==-radius||y==fradius) f=edgecase;
                    if (x==-radius||x==fradius) f*=edgecase;
                    float sprite=texture2D(bokehsprite, vec2((x+radius)/gfactor,(y+radius)/gfactor)).r;
                    //if (length(center-vec2(x,y))<radius){
                    if (sprite>0.0f)
                    {
                            float x1=texCoord.x-x*(1.0f/1920.0f); float y1=texCoord.y-y*(1.0f/1080.0f); x1=clamp(x1,0.0f,1.0f-1.0f/1920.0f); y1=clamp(y1,0.0f,1.0f-1.0f/1080.0f);
                            vec2 gtexCoord=vec2(x1,y1);
                        float r2=texture2D(depthMap, gtexCoord).r;
                        float g2=texture2D(depthMap, gtexCoord).g;
                        float depth2=float(((double(r2)*double(256.0))+double(g2))/double(65536.0));
                        depth2=2*(1.0f-depth2*5000.0f);
                        depth2=clamp(depth2,0.0f,0.99f);
                        if (depth2-depth>=-1.0f/500.0f)
                        {
                            f=f*sprite;
                            vec4 gcolor=texture2D(colorMap, gtexCoord);
                            //gcolor*=blur3[y*3+x];
                            resultcolor+=gcolor*f; d+=f;
                            float brightness=gcolor.r+gcolor.g+gcolor.b;
                            if (brightness>2.0f) {float fb=(brightness-2.0f)*24.0f;resultcolor+=fb*gcolor*f;d+=fb*f;}
                        }
                    }
                    if (x==-radius||x==fradius) xf=edgecase; else xf=1.0f;
                }
                if (y==-radius||y==fradius) yf=edgecase; else yf=1.0f;
            }
            resultcolor/=d;
            //resultcolor=vec4(1.0f,0.0f,0.0f,1.0f);
        }
    }
//resultcolor=texture2D(depthMap, texCoord);
//resultcolor=texture2D(colorMap, texCoord);
//resultcolor=vec4(depth,depth,depth,1.0f);
    gl_FragColor = resultcolor;

}
